#ifndef CONFIGURATIONSERVER_H_
#define CONFIGURATIONSERVER_H_

#include <string>
using namespace std;

namespace Configuration
{

class ConfigurationServer
{
public:
	static ConfigurationServer* GetInstance();
	string GetSimulationEngineKey();
	int GetCommunicationReceiverPort();
	int GetSimulationEnginePort();
	string GetSimulationEngineIP();
	string GetCommunicationReceiverIP();
	int GetMaximumDatagramSize();
	float GetDefaultHardnessInteraction();
	float GetDefaultBouncinessInteraction();
	float GetDefaultSlip1Interaction();
	float GetDefaultSlip2Interaction();
	float GetDefaultFrictionInteraction();
	float GetDefaultGravity();
	int GetContactPointsAmmount();
	bool GetDefaultResponseRequest();
	float GetDefaultWheelJointHardness();
	float GetDefaultWheelJointBounciness();
	float GetDefaultWheelJointMaxTorque();
	int GetDefaultBodyMaterial();
	float GetDefaultBodyMass();
	float GetDefaultPhysicsWorldHardness();
	float GetDefaultPhysicsWorldBounciness();
	string GetCommandRobotControlKey();
	string GetCommandCreateEntityKey();
	string GetCommandInitializeSimulationKey();
	string GetCommandSetTimeStepKey();
	string GetCommandSetStepModeKey();
	string GetCommandSetStepFlagKey();
	string GetCommandSynchronizeKey();
	string GetCommandSetSyncModeKey();
	string GetCommandSetSyncWaitKey();
	string GetCommandSetWorldGravityKey();
	string GetCommandSetWorldBouncinessKey();
	string GetCommandSetWorldHardnessKey();
	string GetCommandRegisterMaterialsInteractionsKey();
	string GetCommandSetEntityPositionKey();
	string GetCommandSaveToFileKey();
	string GetCommandLoadFromFileKey();
	string GetCommandStepsPerIterationKey();
	string GetCommandSetFastModeKey();
	string GetCommandSetAutoAdjustModeKey();
	double GetSyncWait();
	float GetDefaultStepSize();
	
	
protected:
	ConfigurationServer();
private:
	static ConfigurationServer* instance;
	string simulationenginekey;
	int simulationengineport;
	int communicationreceiverport;
	string communicationreceiverip;
	string simulationengineip;
	int maximumdatagramsize;
	string robotentitykey;
	string ballentitykey;
	string fieldentitykey;
	float defaulthardnessinteraction;
	float defaultbouncinessinteraction;
	float defaultslip1interaction;
	float defaultslip2interaction;
	float defaultfrictioninteraction;
	float defaultgravity;
	int contactpointsammount;	
	bool defaultresponserequest;
	float defaultwheeljointhardness;
	float defaultwheeljointbounciness;
	float defaultwheeljointmaxtorque;
	int defaultbodymaterial;
	float defaultbodymass;
	float defaultphysicsworldhardness;
	float defaultphysicsworldbounciness;
	string commandcreateentitykey;
	string commandrobotcontrolkey;
	string commandinitializesimulationkey;
	string commandsettimestepkey;
	string commandsetstepmodekey;
	string commandsetstepflagkey;
	string commandsynchronizekey;
	string commandsetsyncmodekey;
	string commandsetsyncwaitkey;
	string commandsetworldgravitykey;
	string commandsetworldhardnesskey;
	string commandsetworldbouncinesskey;
	string commandsetentitypositionkey;
	string commandregistermaterialsinteractionskey;
	string commandsavetofilekey;
	string commandloadfromfilekey;
	string commandstepsperiterationskey;
	string commandsetfastmodekey;
	string commandsetautoadjustmodekey;
	double syncwait;
	float defaultstepsize;
	

};
}

#endif /*CONFIGURATIONSERVER_H_*/
